<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-Present web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Mzat\AutoRelatedProducts\Helper;

use Extendware\AutoRelatedProducts\Helper\Data as ParentClass;
use Extendware\AutoRelatedProducts\Model\AutoRelatedProductManager;
use Magento\Catalog\Model\ProductFactory;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Data\Form\FormKey;
use Magento\Framework\Registry;
use Magento\Store\Model\StoreManagerInterface;

class Data extends ParentClass
{
    protected $scopeConfig;

    protected $autoRelatedProductManager;

    protected $registry;

    protected $customerSession;

    protected $storeManager;

    protected $productFactory;

    protected $formKey;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        AutoRelatedProductManager $autoRelatedProductManager,
        Registry $registry,
        Session $customerSession,
        StoreManagerInterface $storeManager,
        ProductFactory $productFactory,
        FormKey $formKey
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->autoRelatedProductManager = $autoRelatedProductManager;
        $this->registry = $registry;
        $this->customerSession = $customerSession;
        $this->storeManager = $storeManager;
        $this->productFactory = $productFactory;
        $this->formKey = $formKey;
        parent::__construct(
            $scopeConfig,
            $autoRelatedProductManager,
            $registry,
            $customerSession,
            $storeManager,
            $productFactory,
            $formKey
        );
    }

    public function getAppliedRule($blockType)
    {
        // Check module status
        if (!$this->getModuleStatus()) {
            return false;
        }

        // Get Product
        $product = $this->getProduct();

        $productId = $product?->getId();

        if (!$productId) {
            return false;
        }

        // Get applicable rule-product entries
        $ruleProductIdCollection = $this->autoRelatedProductManager->getRuleSelectedProductCollection($productId);
        if (!$ruleProductIdCollection->getSize()) {
            return false;
        }

        // Extract rule IDs
        $ruleIds = $this->extractArrayValues($ruleProductIdCollection->getData(), 'rule_id');

        // Web-vision custom code start

        // Fetch rule details for the block type
        $ruleCollection = $this->autoRelatedProductManager->getRuleDataModalCollection($ruleIds, $blockType);
        $ruleCollection->addFieldToSelect(['rule_id', 'rule_name', 'customer_group', 'block_title', 'block_title_en', 'block_layout', 'block_position']);
        if (!$ruleCollection->getSize()) {
            return false;
        }

        // Match rules based on customer group and store view
        foreach ($ruleCollection as $rule) {
            if ($this->getCustomerGroupStatus($rule->getCustomerGroup())) {
                return $rule;
            }
        }

        // Web-vision custom code over

        return false;
    }

    public function getBlockTitle($rule)
    {
        $storeCode = $this->storeManager->getStore()->getCode();

        return match ($storeCode) {
            'de' => $rule->getBlockTitle(),
            'en' => $rule->getBlockTitleEn(),
            default => $rule->getRuleName(),
        };
    }
}
