<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-Present web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Mzat\AutoRelatedProducts\Model;

use Extendware\AutoRelatedProducts\Model\DataProvider as ParentClass;
use Extendware\AutoRelatedProducts\Model\ResourceModel\AutoRelated\CollectionFactory;

class DataProvider extends ParentClass
{
    protected $loadedData;

    // @codingStandardsIgnoreStart
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $autoRelatedCollectionFactory,
        array $meta = [],
        array $data = []
    ) {
        $this->collection = $autoRelatedCollectionFactory->create();
        parent::__construct($name, $primaryFieldName, $requestFieldName, $autoRelatedCollectionFactory, $meta, $data);
    }
    // @codingStandardsIgnoreEnd

    public function getData()
    {
        if (isset($this->loadedData)) {
            return $this->loadedData;
        }
        $items = $this->collection->getItems();
        foreach ($items as $autoRelated) {
            // Web-vision custom code start
            $autoRelated->setStoreviews(null);
            // Web-vision custom code over
            $this->loadedData[$autoRelated->getId()] = $autoRelated->getData();
        }

        return $this->loadedData;
    }
}
