<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
declare(strict_types=1);
namespace Mzat\AutoRelatedProducts\ViewModel\Product\Listing;

use Magento\Framework\View\Element\Block\ArgumentInterface;

/**
 * Check is available add to compare.
 */
class PreparePostData implements ArgumentInterface
{
    /**
     * Base template path for components
     */
    private const BASE_TEMPLATE_PATH = 'Extendware_AutoRelatedProducts::product/list/items/';

    /**
     * @var \Magento\Framework\View\LayoutInterface
     */
    protected $layout;

    /**
     * @param \Magento\Framework\View\LayoutInterface $layout
     */
    public function __construct(
        \Magento\Framework\View\LayoutInterface $layout,
    ) {
        $this->layout = $layout;
    }

    /**
     * Get HTML for a component block
     *
     * @param string $type Type of component (sorter, limiter, pagination, loader, success-popup)
     * @param string    $responseStatus
     * @param string    $message
     *
     * @return string
     */
    public function getComponentHtml(string $type, $responseStatus = '', $message = '')
    {
        $block = $this->layout->createBlock(\Magento\Framework\View\Element\Template::class)
            ->setTemplate(self::BASE_TEMPLATE_PATH . $type . '.phtml');

        if ($responseStatus !== '') {
            $block->setData('responseStatus', $responseStatus);
        }

        if ($message !== '') {
            $block->setData('message', $message);
        }

        return $block->toHtml();
    }
}
