<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

declare(strict_types=1);
namespace Mzat\Base\ViewModel;

use Magento\Framework\App\ActionInterface;
use Magento\Framework\Url\EncoderInterface;

/**
 * Provides store encoded pram provider .
 */
class StoreEncodedPramProvider implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var EncoderInterface
     */
    private $encoder;

    /**
     * @param EncoderInterface $encoder
     * @param StoreManagerInterface $storeManager
     * @param UrlInterface $urlBuilder
     */
    public function __construct(
        EncoderInterface $encoder
    ) {
        $this->encoder = $encoder;
    }

    /**
     * Encod Pram function
     *
     * @return void
     */
    public function encodPram()
    {
        return ActionInterface::PARAM_NAME_URL_ENCODED;
    }

    /**
     * Undocumented function
     *
     * @param $url
     *
     * @return void
     */
    public function getStoreEncodPramVal($url)
    {
        return $this->encoder->encode($url);
    }
}
