<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Fenil Timbadiya <fenil@web-vision.de>
*/
namespace Mzat\Calculator\Block;

use Magento\Framework\View\Element\Template;

class Calculator extends Template
{
    /**
     * @var array
     */
    protected $frontendMapping;

    /**
     * @var array
     */
    protected $ihData;

    /**
     * @param Template\Context $context
     * @param array $frontendMapping
     * @param array $ihData
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        array $frontendMapping = [],
        array $ihData = [],
        array $data = []
    ) {
        $this->frontendMapping = $this->convertValuesToNumbers($frontendMapping);
        $this->ihData = $this->convertIhDataToNumbers($ihData);
        parent::__construct($context, $data);
    }

    /**
     * Convert string values to numbers in frontendMapping
     *
     * @param array $data
     *
     * @return array
     */
    private function convertValuesToNumbers(array $data): array
    {
        if (isset($data['isocratic'])) {
            foreach ($data['isocratic'] as &$field) {
                if (isset($field['original']['value']) && is_numeric($field['original']['value'])) {
                    $field['original']['value'] = (float) $field['original']['value'];
                }
                if (isset($field['translation']['value']) && is_numeric($field['translation']['value'])) {
                    $field['translation']['value'] = (float) $field['translation']['value'];
                }
            }
        }

        return $data;
    }

    /**
     * Convert string values to numbers in ihData
     *
     * @param array $data
     *
     * @return array
     */
    private function convertIhDataToNumbers(array $data): array
    {
        $converted = [];
        foreach ($data as $key => $value) {
            if (is_numeric($value)) {
                $converted[$key] = (float) $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }

    /**
     * Get frontend mapping data
     *
     * @return array
     */
    public function getFrontendMapping()
    {
        return $this->frontendMapping;
    }

    /**
     * Get injection helper data
     *
     * @return array
     */
    public function getIhData()
    {
        return $this->ihData;
    }
}
