<?php
namespace Mzat\Catalog\Setup\Patch\Data;

use Magento\Catalog\Model\Product;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class AddMultipleDescriptionsAttributes implements DataPatchInterface
{
    private ModuleDataSetupInterface $moduleDataSetup;
    private EavSetupFactory $eavSetupFactory;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    public function apply(): void
    {
        $this->moduleDataSetup->getConnection()->startSetup();

        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);

        $attributes = [
            'long_description' => 'Long Description',
            'description_2' => 'Description 2',
            'description_3' => 'Description 3',
            'description_4' => 'Description 4',
        ];

        $sortOrder = 35;

        foreach ($attributes as $code => $label) {
            $eavSetup->addAttribute(
                Product::ENTITY,
                $code,
                [
                    'type' => 'text',
                    'label' => $label,
                    'input' => 'textarea',
                    'required' => false,
                    'sort_order' => $sortOrder,
                    'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                    'visible' => true,
                    'frontend_input' => 'textarea',
                    'wysiwyg_enabled' => true,
                    'is_html_allowed_on_front' => true,
                    'visible_on_front' => true,
                    'searchable' => true,
                    'used_in_search' => true,
                    'search_weight' => 10,
                    'used_in_spellcheck' => true,
                    'visible_in_advanced_search' => false,
                    'filterable' => false,
                    'comparable' => true,
                    'group' => 'Content',
                ]
            );
            $sortOrder += 5;
        }

        $this->moduleDataSetup->getConnection()->endSetup();
    }

    public static function getDependencies(): array
    {
        return [];
    }

    public function getAliases(): array
    {
        return [];
    }
}
