<?php
namespace Mzat\Catalog\ViewModel;

use Magento\Framework\Filesystem\DirectoryList;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class AttchementFileName implements ArgumentInterface
{
    protected $directoryList;

    public function __construct(DirectoryList $directoryList)
    {
        $this->directoryList = $directoryList;
    }

    public function getAbsoluteUrl($filePath)
    {
        $mediaDir = $this->directoryList->getPath(UrlInterface::URL_TYPE_MEDIA);
        $relativePath = explode('media/', $filePath);

        return $mediaDir . '/' . $relativePath[1];
    }

    public function getFileName($filePath)
    {
        $absolutePath = $this->getAbsoluteUrl($filePath);

        return $this->getFileMetaDetails($absolutePath)
             ?: ucwords(str_replace(['_', '-'], ' ', pathinfo($filePath, PATHINFO_FILENAME)));
    }

    public function getFileMetaDetails($absolutePath)
    {
        $fileInfo = pathinfo($absolutePath);

        try {
            if (strtolower($fileInfo['extension']) === 'pdf') {
                $pdf = \Zend_Pdf::load($absolutePath);

                return mb_convert_encoding($pdf->properties['Title'], 'UTF-8', 'ISO-8859-1') ?: null;
            }
        } catch (\Exception $e) {
            return null;
        }

        return null;
    }
}
