<?php
namespace Mzat\Catalog\ViewModel;

use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Catalog\Api\Data\CategoryInterface;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;
use Magento\Catalog\Model\Session as CatalogSession;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\LayeredNavigation\Block\Navigation\State;

class ProductLine implements ArgumentInterface
{
    /**
     * Current Category
     *
     * @var CategoryInterface
     */
    protected CategoryInterface $currentCategory;
    /**
     * Current Category ID
     *
     * @var int|null
     */
    protected $categoryId;
    /**
     * @var CatalogSession
     */
    /**
     * @var CatalogSession
     */
    protected CatalogSession $catalogSession;
    /**
     * @var CategoryRepositoryInterface
     */
    protected CategoryRepositoryInterface $categoryRepository;

    /**
     * @var State
     */
    protected State $state;

    /**
     * @var CollectionFactory
     */
    private $categoryFactory;

    /**
     * @var RequestInterface
     */
    protected RequestInterface $request;

    /**
     * CategoryData constructor.
     *
     * @param CatalogSession $catalogSession
     * @param CategoryRepositoryInterface $categoryRepository
     * @param CollectionFactory $categoryFactory
     * @param State $state
     * @param RequestInterface $request
     */
    public function __construct(
        CatalogSession $catalogSession,
        CategoryRepositoryInterface $categoryRepository,
        CollectionFactory $categoryFactory,
        State $state,
        RequestInterface $request
    ) {
        $this->catalogSession = $catalogSession;
        $this->categoryRepository = $categoryRepository;
        $this->categoryFactory = $categoryFactory;
        $this->state = $state;
        $this->request = $request;
    }

    /**
     * @return int|null
     */
    public function getCategoryId()
    {
        $currentCategoryId = $this->request->getParam('id', false);
        if ($currentCategoryId) {
            $this->categoryId = $currentCategoryId;
        }

        return $this->categoryId;
    }

    /**
     * @return CategoryInterface|null
     */
    public function getCategory()
    {
        $categoryId = $this->getCategoryId();
        if (!$categoryId) {
            return null;
        }

        try {
            $this->currentCategory = $this->categoryRepository->get($categoryId);
        } catch (NoSuchEntityException $e) {
            return null;
        }

        return $this->currentCategory;
    }

    /**
     * @param CategoryInterface $category
     *
     * @throws LocalizedException
     *
     * @return array
     */
    private function getChildrenCategories(CategoryInterface $category)
    {
        $children = $category->getChildren();
        if (empty($children) && $category->getLevel() > 3) {
            $children = $category->getParentCategory()->getChildren();
        }

        $childrenIds = explode(',', $children);

        $categoryCollection = $this->categoryFactory->create();
        $categoryCollection
            ->addAttributeToSelect('name')
            ->addAttributeToSelect('url')
            ->addAttributeToSelect('include_in_menu')
            ->addAttributeToSelect('line_sort_order')
            ->addAttributeToSelect('line_title')
            ->addFieldToFilter('entity_id', $childrenIds);
        $categoryCollection->setOrder('line_sort_order', 'ASC');

        return $categoryCollection->getItems();
    }

    /**
     * @throws LocalizedException
     *
     * @return array
     */
    public function getTopCategoryChildren()
    {
        return $this->getChildrenCategories($this->getCategory());
    }
}
