<?php
namespace Mzat\CatalogHidePrice\Plugin;

class FinalPriceBox
{
    protected $_productRepository;

    public function __construct(\Magento\Catalog\Api\ProductRepositoryInterface $productRepository)
    {
        $this->_productRepository = $productRepository;
    }

    public function afterToHtml(\Magento\Catalog\Pricing\Render\FinalPriceBox $subject, $result)
    {
        $id = $subject->getSaleableItem()->getId();
        $product = $this->_productRepository->getById($id);

        if ($product->getData('price_on_request')) {
            return '';
        }

        return $result;
    }
}
