<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Mzat\CategoriesFilter\Block;

use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template\Context;

class CategoriesFilterRenderer extends \Magento\Framework\View\Element\Template
{
    public const XML_PATH_DISCOUNT_CATEGORY_FILTER = 'mzat/categoriesfilter/';

    protected $categoryRepository;

    protected $categoryCollectionFactory;

    protected $scopeConfig;

    protected $_registry;

    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig,
        CategoryRepositoryInterface $categoryRepository,
        CollectionFactory $categoryCollectionFactory,
        Registry $registry,
        array $data = []
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->categoryRepository = $categoryRepository;
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->_registry = $registry;
        parent::__construct($context, $data);
    }

    /**
     * GetConfigValue function
     *
     * @param string $value
     *
     * @return void
     */
    public function getConfigValue($value)
    {
        $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;

        return $this->scopeConfig->getValue(self::XML_PATH_DISCOUNT_CATEGORY_FILTER . $value, $storeScope);
    }

    /**
     * GetIsEnabled
     *
     * @return void
     */
    public function getIsEnabled()
    {
        return $this->getConfigValue('is_enable');
    }

    /**
     * Get Filter Title
     *
     * @return void
     */
    public function getFilterTitle()
    {
        return $this->getConfigValue('filter_title');
    }

    /**
     * Get Filter CategoryId
     *
     * @return void
     */
    public function getFilterCategoryID()
    {
        return $this->getConfigValue('category_id');
    }

    /**
     * Get Category List
     *
     * @return void
     */
    public function getCategoryList()
    {
        $categoryId = $this->getFilterCategoryID();
        $categoryCollection = $this->categoryCollectionFactory->create();

        if ($categoryId) {
            $category = $this->categoryRepository->get($categoryId);
            $children = $category->getChildren();

            $categoryCollection
                ->addAttributeToSelect(['entity_id', 'name', 'url', 'children'])
                ->addFieldToFilter('entity_id', ['in' => $children]);
        }

        return $categoryCollection;
    }

    /**
     * Get CurrentCategory
     *
     * @return void
     */
    public function getCurrentCategory()
    {
        return $this->_registry->registry('current_category');
    }

    public function getSubcategories($children)
    {
        $subcategoryCollection = $this->categoryCollectionFactory->create();
        $subcategoryCollection
            ->addAttributeToSelect(['entity_id', 'name', 'url', 'children'])
            ->addFieldToFilter('entity_id', ['in' => $children]);

        return $subcategoryCollection;
    }
}
