<?php
/**
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 *
 * @category    Mzat
 *
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Harun <harun@web-vision.de>
 **/
declare(strict_types=1);
namespace Mzat\Category\Plugin\Model;

use Magento\Catalog\Model\Category;

class CategoryUrl
{
    /**
     * If defined, sets the Category URL to the value defined in the 'custom_category_url' field in backend.
     *
     * @param Category $subject
     * @param string $result
     *
     * @return mixed
     */
    public function afterGetUrl(Category $subject, string $result)
    {
        if ($subject->getCustomCategoryUrl()) {
            $result = $subject->getCustomCategoryUrl();
        }

        return $result;
    }
}
