<?php
/**
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 *
 * @category    Mzat
 *
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Harun <harun@web-vision.de>
 **/
declare(strict_types=1);
namespace Mzat\Category\Plugin\Model;

use Magento\Catalog\Model\ResourceModel\Category\Collection;
use Magento\Framework\Exception\LocalizedException;

class CollectionUrlAttr
{
    /**
     * Adds the custom attribute 'custom_category_url' to the Category Collection
     *
     * @param Collection $subject
     * @param bool $printQuery
     * @param bool $logQuery
     *
     * @throws LocalizedException
     *
     * @return array|false[]
     */
    public function beforeLoad(Collection $subject, bool $printQuery = false, bool $logQuery = false): array
    {
        $subject->addAttributeToSelect('custom_category_url');

        return [$printQuery, $logQuery];
    }
}
