<?php
/**
 * Copyright ©  All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);
namespace Mzat\Category\ViewModel;

use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;
use Magento\Store\Model\StoreManagerInterface;

class CategoryDescriptions implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var CollectionFactory
     */
    private $categoryFactory;

    /**
    * @var \Magento\Store\Model\StoreManagerInterface
    */
    private $storeManager;

    /**
     * CategoryDescriptions constructor.
     *
     * @param CollectionFactory $categoryFactory
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        CollectionFactory $categoryFactory,
        StoreManagerInterface $storeManager
    ) {
        $this->categoryFactory = $categoryFactory;
        $this->storeManager = $storeManager;
    }

    /**
     * @return string
     */
    public function getCategoryDescriptions()
    {
        return $this->categoryFactory->create()
            ->addAttributeToSelect(['description', 'name'])->addAttributeToFilter('description', ['neq' => ''])
            ->setStore($this->storeManager->getStore()->getId());
    }
}
