<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Mzat\CategoryProductListSelect\Model\Category\Attribute\Source;

/**
 * CategoryPagination class
 */
class CategoryPagination extends \Magento\Eav\Model\Entity\Attribute\Source\AbstractSource
{
    public const XML_PATH_LIST_MODE = 'catalog/frontend/list_mode';

    public const XML_PATH_LIST_ALLOW_ALL = 'catalog/frontend/list_allow_all';

    /**
    * @var \Magento\Framework\App\Config\ScopeConfigInterface
    */
    protected $scopeConfig;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(\Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * GetAllOptions
     *
     * @return array
     */
    public function getAllOptions()
    {
        $avilable_lmit_array = [];
        $avilable_lmit = $this->getAvailableLimit();
        $i = 0;
        foreach ($avilable_lmit as $key => $value) {
            $avilable_lmit_array[$i]['value'] = $key;
            $avilable_lmit_array[$i]['label'] = $value;
            $i++;
        }

        return $avilable_lmit_array;
    }

    /**
     * GetConfig function
     *
     * @return void
     */
    public function getConfig()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_LIST_MODE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }

    /**
     * Retrieve available limits for specified view mode
     *
     * @param string $viewMode
     *
     * @return array
     */
    public function getAvailableLimit(): array
    {
        $viewMode = $this->getConfig();

        $perPageConfigPath = 'catalog/frontend/' . $viewMode . '_per_page_values';
        $perPageValues = (string)$this->scopeConfig->getValue($perPageConfigPath, \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $perPageValues = explode(',', $perPageValues);
        $perPageValues = array_combine($perPageValues, $perPageValues);
        if ($this->scopeConfig->isSetFlag(self::XML_PATH_LIST_ALLOW_ALL, \Magento\Store\Model\ScopeInterface::SCOPE_STORE)) {
            return $perPageValues + ['1014014' => 'All'];
        }

        return $perPageValues;
    }
}
