<?php
namespace Mzat\CategoryProductListSelect\Plugin\Product\ProductList;

/**
 * ToolbarPlugin class
 */
class ToolbarPlugin
{
    public const XML_PATH_LIST_PER_PAGE = 'catalog/frontend/list_per_page';

    /**
    * @var \Magento\Framework\App\Config\ScopeConfigInterface
    */
    protected $scopeConfig;

    /**
    * Core registry
    *
    * @var \Magento\Framework\Registry
   */
    protected $_coreRegistry;

    /**
    * @var \Magento\Framework\App\Request\Http $request
    */
    protected $request;

    /**
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\Request\Http $request
     */
    public function __construct(
        \Magento\Framework\Registry $registry,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\Request\Http $request
    ) {
        $this->_coreRegistry = $registry;
        $this->scopeConfig = $scopeConfig;
        $this->request = $request;
    }

    /**
     * Get specified products limit display per page
     *
     * @param mixed $result
     *
     * @return string
     */
    public function beforegetLimit($result)
    {
        $limit = '';
        $limit = $this->getConfig();
        if (array_key_exists('product_list_limit', $this->request->getParams())) {
            $limit = $this->request->getParam('product_list_limit');
        } else {
            if ($this->request->getFullActionName() == 'catalog_category_view') {
                $category = $this->_coreRegistry->registry('current_category');
                if (array_key_exists('product_list_select', $category->getData())) {
                    $categor_limit = $category['product_list_select'];
                    if ($categor_limit == 1014014) {
                        $limit = 'all';
                    } else {
                        $limit = (int)$categor_limit;
                    }
                }
            }
        }
        $result = $result->setData('_current_limit', $limit);

        return $result;
    }

    /**
     * GetConfig function
     *
     * @return void
     */
    public function getConfig()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_LIST_PER_PAGE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }
}
