<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Mzat\CategoryProductListSelect\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;

/**
 * CategoryProductListSelect class
 */
class CategoryProductListSelect implements ArgumentInterface
{
    public const XML_PATH_LIST_PER_PAGE = 'catalog/frontend/list_per_page';

    /**
    * @var \Magento\Framework\App\Config\ScopeConfigInterface
    */
    protected $scopeConfig;

    /**
    * @var \Magento\Framework\App\Request\Http $request
    */
    protected $request;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\Request\Http $request
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\Request\Http $request
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->request = $request;
    }

    /**
     * GetSlectedProductPage function
     *
     * @param $selected_data
     *
     * @return void
     */
    public function getSlectedProductPage($selected_data)
    {
        if (array_key_exists('product_list_limit', $this->request->getParams())) {
            $selected_value = $this->request->getParam('product_list_limit');
        } elseif ($selected_data) {
            if ($selected_data == 1014014) {
                $selected_value = 'all';
            } else {
                $selected_value = (int)$selected_data;
            }
        } else {
            $selected_value = $this->getConfig();
        }

        return $selected_value;
    }

    /**
     * GetConfig function
     *
     * @return void
     */
    public function getConfig()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_LIST_PER_PAGE, \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }
}
