<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2025 web-vision GmbH (https://www.web-vision.de)
 * @author      Bushra Asif <ba@web-vision.de>
 */
namespace Mzat\CategoryProductListSelect\ViewModel;

use Magento\Framework\App\RequestInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class NavigationFilters implements ArgumentInterface
{
    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     *  NavigationFilters constructor.
     *
     * @param RequestInterface $request
     */
    public function __construct(
        RequestInterface $request
    ) {
        $this->request = $request;
    }

    /**
     * Returns a JSON-encoded array of indices for active navigation filters.
     *
     * @param array $displayedFilters
     *
     * @return string
     */
    public function getActiveNavigationFilter($displayedFilters)
    {
        $requestParams = array_keys($this->request->getParams());
        $activeFilters = [];
        foreach ($displayedFilters as $filter) {
            $requestVar = $filter->getRequestVar();
            if (in_array($requestVar, $requestParams)) {
                $activeFilters[] = $requestVar;
            }
        }

        return json_encode($activeFilters);
    }
}
