<?php
namespace Mzat\ContentNavigation\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;

class NavigationLinks extends \Magento\Framework\View\Element\Template implements ArgumentInterface
{
    public function checkActiveSections()
    {
        $activeSections = [];
        $navLinks = [
            'category.products' => ['products', 'Products'],
            't3.technical.section' => ['technical', 'Technical Data'],
            't3.applications.section' => ['applications', 'Applications'],
            't3.downloads.section' => ['downloads', 'Downloads'],
            't3.news.section' => ['news', 'Offers / News'],
        ];

        foreach ($navLinks as $sectionBlock => $sectionName):
            $blockContent = $this->getLayout()->getBlock($sectionBlock)->getChildHtml();

            if ($blockContent):
                $activeSections[$sectionName[0]] = $sectionName[1];
            endif;
        endforeach;

        return $activeSections;
    }
}
