<?php
/**
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 *
 * @category    Mzat
 *
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Harun Mujic <harun@web-vision.de>
 */
declare(strict_types=1);
namespace Mzat\CustomCheckoutData\Magewire\Checkout;

use Exception;
use Magento\Checkout\Model\Session as SessionCheckout;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Quote\Api\CartRepositoryInterface;
use Magewirephp\Magewire\Component;

class OrderComment extends Component
{
    /**
     * @var string|null
     */
    public ?string $comment = null;

    /**
     * @var bool
     */
    public bool $saved = false;

    /**
     * @var SessionCheckout
     */
    protected SessionCheckout $sessionCheckout;

    /**
     * @var CartRepositoryInterface
     */
    protected CartRepositoryInterface $quoteRepository;

    /**
     * @param SessionCheckout $sessionCheckout
     * @param CartRepositoryInterface $quoteRepository
     */
    public function __construct(
        SessionCheckout $sessionCheckout,
        CartRepositoryInterface $quoteRepository
    ) {
        $this->sessionCheckout = $sessionCheckout;
        $this->quoteRepository = $quoteRepository;
    }

    /**
     * Set the Order comment value which will be used by magewire
     *
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    public function mount(): void
    {
        $quote = $this->sessionCheckout->getQuote();
        $comment = $quote->getCustomOrderComment();

        $this->comment = $comment;
    }

    /**
     * Save the Order comment value to the Quote on input update
     *
     * @param string $value
     *
     * @return string
     */
    public function updatingComment(string $value): string
    {
        try {
            $quote = $this->sessionCheckout->getQuote();
            $quote->setCustomOrderComment($value);

            $this->quoteRepository->save($quote);
            $this->saved = true;
        } catch (LocalizedException| Exception $exception) {
            $this->dispatchErrorMessage('Something went wrong while saving your order comment. Please try again.');
        }

        return $value;
    }
}
