<?php
/**
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 *
 * @category    Mzat
 *
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Harun Mujic <harun@web-vision.de>
 */
declare(strict_types=1);
namespace Mzat\CustomCheckoutData\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Psr\Log\LoggerInterface;

class SaveCustomerReference implements ObserverInterface
{
    /**
     * @var LoggerInterface
     */
    private LoggerInterface $logger;

    /**
     * @param LoggerInterface $logger
     */
    public function __construct(
        LoggerInterface $logger
    ) {
        $this->logger = $logger;
    }

    /**
     * Save Cost Center values from Quote to the Order
     *
     * @param EventObserver $observer
     *
     * @return void
     */
    public function execute(EventObserver $observer): void
    {
        try {
            $quote = $observer->getQuote();
            $order = $observer->getOrder();

            $order->setData('custom_cost_center', $quote->getData('custom_cost_center'));
            $order->setData('custom_order_number', $quote->getData('custom_order_number'));
            $order->setData('custom_order_comment', $quote->getData('custom_order_comment'));
        } catch (NoSuchEntityException $e) {
            $this->logger->error($e->getMessage());
        }
    }
}
