<?php
/**
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 *
 * @category    Mzat
 *
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Harun Mujic <harun@web-vision.de>
 */
declare(strict_types=1);
namespace Mzat\CustomCheckoutData\Plugin\Quote\Api;

use Exception;
use Magento\Quote\Api\CartRepositoryInterface as Subject;
use Magento\Quote\Api\Data\CartInterface;
use Magento\Quote\Api\Data\CartSearchResultsInterface;
use Psr\Log\LoggerInterface;

class CartRepository
{
    /**
     * @var LoggerInterface
     */
    protected LoggerInterface $logger;

    /**
     * @param LoggerInterface $logger
     */
    public function __construct(
        LoggerInterface $logger
    ) {
        $this->logger = $logger;
    }

    /**
     * Set the Customer reference data to quote on get()
     *
     * @param Subject $subject
     * @param CartInterface $quote
     *
     * @return CartInterface
     */
    public function afterGet(Subject $subject, CartInterface $quote): CartInterface
    {
        $this->setCustomData($quote);

        return $quote;
    }

    /**
     * Set the Customer reference data to quote on getList()
     *
     * @param Subject $subject
     * @param CartSearchResultsInterface $searchResult
     *
     * @return CartSearchResultsInterface
     */
    public function afterGetList(Subject $subject, CartSearchResultsInterface $searchResult): CartSearchResultsInterface
    {
        foreach ($searchResult->getItems() as $quote) {
            $this->setCustomData($quote);
        }

        return $searchResult;
    }

    /**
     * Set the Customer reference data to the given quote
     *
     * @param CartInterface $quote
     */
    public function setCustomData(CartInterface $quote): void
    {
        try {
            $quote->setCustomOrderNumber($quote->getCustomOrderNumber());
            $quote->setCustomOrderComment($quote->getCustomOrderComment());
        } catch (Exception $exception) {
            $this->logger->critical($exception->getMessage(), ['exception' => $exception]);
        }
    }

    /**
     * Set the Customer reference data to quote on save()
     *
     * @param Subject $subject
     * @param CartInterface $quote
     *
     * @return array
     */
    public function beforeSave(Subject $subject, CartInterface $quote): array
    {
        try {
            $orderNumber = $quote->getCustomOrderNumber();
            $orderComment = $quote->getCustomOrderComment();

            is_string($orderNumber) && $quote->setCustomOrderNumber($orderNumber);
            is_string($orderComment) && $quote->setCustomOrderComment($orderComment);
        } catch (Exception $exception) {
            $this->logger->critical($exception->getMessage(), ['exception' => $exception]);
        }

        return [$quote];
    }
}
