<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Bushra Asif <bushra@web-vision.de>
 */
namespace Mzat\CustomProductAttribute\Plugin\Block\Adminhtml\Product\Attribute\Edit\Tab;

use Magento\Framework\Registry;
use Mzat\CustomProductAttribute\Model\Config\Source\PriorityOptions;

class Front
{
    /**
     * @var PriorityOptions
     */
    protected $priorityOptions;

    /**
     * @var Registry
     */
    protected $registry;

    /**
     * @param PriorityOptions $priorityOptions
     * @param Registry $registry
     */
    public function __construct(
        PriorityOptions $priorityOptions,
        Registry $registry
    ) {
        $this->priorityOptions = $priorityOptions;
        $this->registry = $registry;
    }

    /**
     * Get form HTML
     *
     * @return string
     */
    public function aroundGetFormHtml(
        \Magento\Catalog\Block\Adminhtml\Product\Attribute\Edit\Tab\Front $subject,
        \Closure $proceed
    ) {
        $form = $subject->getForm();
        $fieldset = $form->getElement('front_fieldset');
        // Retrieve the attribute object from the registry
        $attribute = $this->registry->registry('entity_attribute');
        // Retrieve the saved value
        $savedValue = $attribute ? $attribute->getData('is_attribute_priority') : '';

        $fieldset->addField(
            'is_attribute_priority',
            'select',
            [
                'name' => 'is_attribute_priority',
                'label' => __('Priority'),
                'title' => __('Priority'),
                'values' => $this->priorityOptions->toOptionArray(),
                'value' => $savedValue,
            ]
        );

        return $proceed();
    }
}
