<?php
namespace Mzat\Customer\ViewModel;

use Magento\Framework\App\Http\Context as httpContext;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class Customer implements ArgumentInterface
{
    /**
     * @var httpContext
     */
    protected $httpContext;

    public function __construct(
        httpContext $httpContext
    ) {
        $this->httpContext = $httpContext;
    }

    /**
     * @return string
     */
    public function getCustomerNameAcronym(): string
    {
        if (!$this->httpContext->getValue(\Magento\Customer\Model\Context::CONTEXT_AUTH)) {
            return '';
        }

        $customerName = $this->httpContext->getValue('customer_name');
        $acronym = '';

        foreach (explode(' ', $customerName) as $w) {
            $acronym .= $w[0];
        }

        return strtoupper($acronym);
    }
}
