<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Bushra Asif <bushra@web-vision.de>
 */
namespace Mzat\CustomerImport\Plugin;

use Magento\CustomerImportExport\Model\Import\Customer as CustomerImport;
use Magento\Framework\App\ResourceConnection;

class CustomerImportPlugin
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * CustomerImportPlugin constructor.
     *
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(ResourceConnection $resourceConnection)
    {
        $this->resourceConnection = $resourceConnection;
    }

    /**
     * Around plugin for validateRow method.
     *
     * @param CustomerImport $subject
     * @param callable $proceed
     * @param array $rowData
     * @param int $rowNumber
     *
     * @return bool
     */
    public function aroundValidateRow(CustomerImport $subject, callable $proceed, array $rowData, $rowNumber)
    {
        if (isset($rowData[CustomerImport::COLUMN_EMAIL])) {
            $email = strtolower(trim($rowData[CustomerImport::COLUMN_EMAIL]));

            // Check if the email already exists in the customer table
            $connection = $this->resourceConnection->getConnection();
            $customerTable = $connection->getTableName('customer_entity');
            $select = $connection->select()
                ->from($customerTable, 'entity_id')
                ->where('email = ?', $email)
                ->limit(1);

            $existingCustomerId = $connection->fetchOne($select);

            if ($existingCustomerId) {
                // Skip the row by adding it to the error aggregator
                $subject->getErrorAggregator()->addRowToSkip($rowNumber);

                // Return false to indicate that the row is invalid and should not proceed further
                return false;
            }
        }

        // Proceed with the original validation if no duplicate found
        return $proceed($rowData, $rowNumber);
    }
}
