<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Mzat\FixSmileElastic\Helper;

use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\StoreManagerInterface;
use Smile\ElasticsuiteCatalog\Helper\Autocomplete as ParentClass;
use Smile\ElasticsuiteCatalog\Helper\ProductAttribute;

class Autocomplete extends ParentClass
{
    public const ACTION_AUTOCOMPLATE = 'search_ajax_suggest';

    public const ACTION_SEARCH_PAGE = 'catalogsearch_result_index';

    /**
     * @var ProductAttribute
     */
    private $attributeHelper;

    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * Constructor.
     *
     * @param Context               $context         Helper context.
     * @param StoreManagerInterface $storeManager    Store manager.
     * @param ProductAttribute      $attributeHelper Attribute helper.
     */
    public function __construct(Context $context, StoreManagerInterface $storeManager, ProductAttribute $attributeHelper)
    {
        $this->attributeHelper = $attributeHelper;
        $this->request = $context->getRequest();
        parent::__construct($context, $storeManager, $attributeHelper);
    }

    /**
     * Returns max size for a given type of autocomplete results
     *
     * @param string $type The type of autocomplete element.
     *
     * @return int
     */
    public function getMaxSize($type)
    {
        // Web-vision Custom code start
        $maxValue = (int) $this->getConfigValue(sprintf('%s_autocomplete/max_size', $type));

        if ($type !== 'category') {
            return $maxValue;
        }

        $actionName = $this->request->getFullActionName();

        $isAutocomplete = $this->isShowAutocomplete($type) && self::ACTION_AUTOCOMPLATE === $actionName;
        $isSearchPage = $this->isShowSearchPage($type) && self::ACTION_SEARCH_PAGE === $actionName;

        return ($isAutocomplete || $isSearchPage) ? $maxValue : 0;
        // Web-vision Custom code end
    }

    /**
     * Is show into auto complete popup
     *
     * @param string $type The type of autocomplete element.
     *
     * @return int
     */
    public function isShowAutocomplete($type)
    {
        return (int) $this->getConfigValue(sprintf('%s_autocomplete/show_autocomplete', $type));
    }

    /**
     * Is show into search page
     *
     * @param string $type The type of autocomplete element.
     *
     * @return int
     */
    public function isShowSearchPage($type)
    {
        return (int) $this->getConfigValue(sprintf('%s_autocomplete/show_search_page', $type));
    }

    /**
     * Returns if an autocomplete type is enabled or not.
     *
     * @param string $type The type of autocomplete element.
     *
     * @return bool
     */
    public function isEnabled($type)
    {
        // Web-vision Custom code start
        return $this->getMaxSize($type);
        // Web-vision Custom over over
    }

    /**
     * Retrieve a configuration value by its key
     *
     * @param string $key The configuration key
     *
     * @return mixed
     */
    public function getConfigValue($key)
    {
        return $this->scopeConfig->getValue(
            \Smile\ElasticsuiteCore\Helper\Autocomplete::AUTOCOMPLETE_SETTINGS_CONFIG_XML_PREFIX . '/' . $key,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }
}
