<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Mzat\HrefLangFix\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\UrlInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class Data extends AbstractHelper
{
    public const DEFAULT_PRODUCT_LIST_LIMIT = 'catalog/frontend/grid_per_page';

    public const ACTION_CATALOG_CATEGORY_VIEW = 'catalog_category_view';

    public const ACTION_CATALOG_PRODUCT_VIEW = 'catalog_product_view';

    public const ACTION_CMS_INDEX_INDEX = 'cms_index_index';

    public const ACTION_CONTACT_INDEX_INDEX = 'contact_index_index';

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @var UrlInterface
     */
    protected $urlInterface;

    /**
     * Init
     *
     * @param Context $context
     */
    public function __construct(
        Context $context,
        protected StoreManagerInterface $storeManager
    ) {
        $this->scopeConfig = $context->getScopeConfig();
        $this->request = $context->getRequest();
        $this->urlInterface = $context->getUrlBuilder();
        parent::__construct($context);
    }

    /**
     * Get default product per page count
     *
     * @return string
     */
    public function getDefaultProductPerPageCount()
    {
        return $this->scopeConfig->getValue(
            self::DEFAULT_PRODUCT_LIST_LIMIT,
            ScopeInterface::SCOPE_STORE
        ) ?? 12;
    }

    /**
     * Get current url with param
     *
     * @return string
     */
    public function getCurrentUrlWithParam()
    {
        return $this->urlInterface->getCurrentUrl();
    }

    /**
     * Get request object
     *
     * @return RequestInterface
     */
    public function getRequestObj()
    {
        return $this->request;
    }

    /**
     * Get store manager object
     *
     * @return StoreManagerInterface
     */
    public function getStoreManagerObj()
    {
        return $this->storeManager;
    }
}
