<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Mzat\HrefLangFix\Observer;

use Magento\Catalog\Model\Layer\Resolver as LayerResolver;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\View\Page\Config as PageConfig;
use Mzat\HrefLangFix\Helper\Data as HrefLangHelper;

class AddSeoPaginationLinks implements ObserverInterface
{
    /**
     * Constructor
     *
     * @param PageConfig $pageConfig
     * @param LayerResolver $layerResolver
     * @param HrefLangHelper $hrefLangHelper
     */
    public function __construct(
        protected PageConfig $pageConfig,
        protected LayerResolver $layerResolver,
        protected HrefLangHelper $hrefLangHelper
    ) {
    }

    /**
     * Execute.
     *
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @return void
     */

    /**
     * Execute.
     *
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @return void
     */
    public function execute(Observer $observer)
    {
        $currentUrl = $this->hrefLangHelper->getCurrentUrlWithParam();
        $actionName = $this->hrefLangHelper->getRequestObj()->getFullActionName();
        switch ($actionName) {
            case HrefLangHelper::ACTION_CATALOG_CATEGORY_VIEW:
                $page = (int) $this->hrefLangHelper->getRequestObj()->getParam('p', 1);

                // Get current category
                $currentCategory = $this->layerResolver->get()->getCurrentCategory();
                if ($currentCategory instanceof \Magento\Catalog\Model\Category && $currentCategory->getId()) {

                    $categoryBaseUrl = $currentCategory->getUrl();

                    // Add Canonical
                    $canonicalUrl = $page == 1 ? $categoryBaseUrl : $categoryBaseUrl . '?p=' . $page;
                    $this->setCanonical($canonicalUrl);
                }

                break;

            case HrefLangHelper::ACTION_CMS_INDEX_INDEX:
                // set homepage url
                $currentUrl = $this->hrefLangHelper->getStoreManagerObj()->getStore()->getBaseUrl();
                $this->setCanonical($currentUrl, true);

                break;

            case HrefLangHelper::ACTION_CATALOG_PRODUCT_VIEW:
                // skip for product page
                $this->setCanonical(false);

                break;

            case HrefLangHelper::ACTION_CONTACT_INDEX_INDEX:
                // set for contect page
                $this->setCanonical($currentUrl, true);

                break;

            default:
                // set Canonical to other pages
                $this->setCanonical($currentUrl);

                break;
        }
    }

    /**
     * Set canonical url to page
     *
     * @param string $currentUrl
     * @param bool $removeSlash
     *
     * @return void
     */
    public function setCanonical($currentUrl, $removeSlash = false)
    {
        if ($currentUrl) {
            $currentUrl = $removeSlash ? rtrim($currentUrl, '/') : $currentUrl;
            // set canonical to page
            $this->pageConfig->addRemotePageAsset(
                $currentUrl,
                'canonical',
                ['attributes' => ['rel' => 'canonical']]
            );
        }
    }
}
