<?php
/*
 *   web-vision GmbH
 *   Do not edit or add to this file if you wish to upgrade Magento to newer
 *   versions in the future. If you wish to customize Magento for your
 *   needs please refer to https://www.web-vision.de for more information.
 *   @category    Mzat
 *   @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 *   @author      Parth Trivedi <parth@web-vision.de>
 */

declare(strict_types=1);
namespace Mzat\HrefLangFix\Rewrite\BrunoCanada\HrefLang\Block;

use BrunoCanada\HrefLang\Service\HrefLang\AlternativeUrlService;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Store\Model\Group;
use Magento\Store\Model\Website;
use Mzat\HrefLangFix\Helper\Data as HrefLangHelper;

class HrefLang extends Template
{
    /**
     * @param Context $context
     * @param AlternativeUrlService $alternativeUrlService
     * @param HrefLangHelper $hrefLangHelper
     * @param array $data
     */
    public function __construct(
        Context $context,
        private AlternativeUrlService $alternativeUrlService,
        protected HrefLangHelper $hrefLangHelper,
        array $data = []
    ) {
        parent::__construct($context, $data);
    }

    /**
     * @return array
     */
    public function getAlternatives()
    {
        $data = [];
        foreach ($this->getStores() as $store) {
            $url = $this->getStoreUrl($store);
            if ($url) {
                $data[$this->getLocaleCode($store)] = $url;
                // web-v code start
                if ($store->isDefault()) {
                    $data['x-default'] = $url;
                }
                // web-v code end
            }
        }

        return $data;
    }

    /**
     * @param $store
     *
     * @return string
     */
    private function getStoreUrl($store)
    {
        $hrefLangUrl = $this->alternativeUrlService->getAlternativeUrl($store);
        $actionName = $this->hrefLangHelper->getRequestObj()->getFullActionName();
        if (HrefLangHelper::ACTION_CMS_INDEX_INDEX == $actionName) {
            $hrefLangUrl = rtrim($hrefLangUrl, '/');
        }

        return $hrefLangUrl;
    }

    /**
     * @param $store
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     *
     * @return bool
     */
    private function isCurrentStore($store)
    {
        return $store->getId() == $this->_storeManager->getStore()->getId();
    }

    /**
     * @param $store
     *
     * @return array|string|string[]
     */
    private function getLocaleCode($store)
    {
        $localeCode = $this->_scopeConfig->getValue('general/locale/code', 'stores', $store->getId());

        return str_replace('_', '-', $localeCode);
    }

    /**
     * @return array|\Magento\Store\Api\Data\StoreInterface[]
     */
    private function getStores()
    {
        $config = $this->_scopeConfig->getValue('seo/hreflang/same_website_only');
        if ($config === null || $config === '1') {
            return $this->getSameWebsiteStores();
        }

        return $this->_storeManager->getStores();
    }

    /**
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return array
     */
    private function getSameWebsiteStores()
    {
        $stores = [];
        /** @var Website $website */
        $website = $this->_storeManager->getWebsite();
        foreach ($website->getGroups() as $group) {
            /** @var Group $group */
            foreach ($group->getStores() as $store) {
                $stores[] = $store;
            }
        }

        return $stores;
    }

    /**
     * Get store URL without store code
     *
     * @param int $storeId
     *
     * @return string
     */
    public function getStoreUrlWithoutCode($storeId)
    {
        return $this->_storeManager->getStore($storeId)->getBaseUrl(UrlInterface::URL_TYPE_WEB);
    }
}
