<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 * @author      Parth Trivedi <parth@web-vision.de>
 */

declare(strict_types=1);
namespace Mzat\HtmlToPdf\Block\Datasheet;

use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\ProductFactory;
use Magento\Framework\Pricing\PriceCurrencyInterface;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template\Context;
use Psr\Log\LoggerInterface;

class Attributes extends \Magento\Catalog\Block\Product\View\Attributes
{
    /**
     * @param Context $context
     * @param Registry $registry
     * @param PriceCurrencyInterface $priceCurrency
     * @param ProductFactory $productFactory
     * @param LoggerInterface $logger
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        PriceCurrencyInterface $priceCurrency,
        protected ProductFactory $productFactory,
        protected LoggerInterface $logger,
        array $data = []
    ) {
        parent::__construct($context, $registry, $priceCurrency, $data);
    }

    /**
     * Returns a Product which is passed for pdf download
     *
     * @return Product
     */
    public function getProduct()
    {
        try {
            $id = $this->getProductId();
            $this->_product = $this->productFactory->create()->load($id);
        } catch (\Exception $e) {
            $this->logger->critical($e->getMessage());
        }

        return $this->_product;
    }
}
