<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 * @author      Parth Trivedi <parth@web-vision.de>
 */

declare(strict_types=1);
namespace Mzat\HtmlToPdf\Block\Datasheet;

use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template as TemplateAlias;
use Magento\Framework\View\Element\Template\Context;

class Index extends TemplateAlias
{
    /**
     * @param Context $context
     * @param Registry $registry
     * @param array $data
     */
    public function __construct(
        Context $context,
        protected Registry $registry,
        array $data = []
    ) {
        parent::__construct($context, $data);
    }

    /**
     * Get current product
     *
     * @return mixed|null
     */
    public function getCurrentProduct()
    {
        return $this->registry->registry('current_product');
    }

    /**
     * Get PDF download URL
     *
     * @return false|string
     */
    public function getDownloadPdfUrl()
    {
        if ($currentProduct = $this->getCurrentProduct()) {
            return $this->getUrl('mzat_htmltopdf/datasheet/index', ['id' => $currentProduct->getId()]);
        }

        return false;
    }
}
