<?php
namespace Mzat\HtmlToPdf\ViewModel;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\StoreManagerInterface;

class ImagePathResolver implements ArgumentInterface
{
    public function __construct(
        private DirectoryList $directoryList,
        private StoreManagerInterface $storeManager
    ) {
    }

    /**
     * Resolve a local image path from a given Magento media URL
     *
     * @param string $imageUrl
     *
     * @return string
     */
    public function resolve(string $imageUrl): string
    {
        $mediaDir = $this->directoryList->getPath(DirectoryList::MEDIA);
        $mediaBaseUrl = $this->storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_MEDIA);

        $relativePath = str_replace($mediaBaseUrl, '', $imageUrl);
        $localImagePath = $mediaDir . '/' . ltrim($relativePath, '/');

        if (!is_file($localImagePath)) {
            $localImagePath = $mediaDir . '/catalog/product/placeholder/default_image.jpg';
        }

        return $localImagePath;
    }
}
