<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Harun <harun@web-vision.de>
 */
declare(strict_types=1);
namespace Mzat\NavDisplayConfig\Plugin;

use Hyva\Theme\Service\Navigation;
use Magento\Catalog\Model\Category;
use Magento\Catalog\Model\ResourceModel\Category\Collection;
use Magento\Framework\Exception\LocalizedException;

class NavigationPlugin
{
    /**
     * Adds additional attributes to the category tree
     *
     * @param Navigation $subject
     * @param Collection $collection
     *
     * @throws LocalizedException
     *
     * @return Collection
     */
    public function afterGetCategoryTree(Navigation $subject, Collection $collection): Collection
    {
        $collection->addAttributeToSelect(['nav_show_all_link', 'nav_subcats_num']);

        return $collection;
    }

    /**
     * Adds additional items to the array
     *
     * @param Navigation $subject
     * @param array $categoryArray
     * @param Category $category
     *
     * @return array
     */
    public function afterGetCategoryAsArray(Navigation $subject, array $categoryArray, Category $category): array
    {
        $categoryArray['nav_show_all_link'] = $category->getData('nav_show_all_link');
        $categoryArray['nav_subcats_num'] = $category->getData('nav_subcats_num');

        return $categoryArray;
    }
}
