<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
declare(strict_types=1);
namespace Mzat\OrderWithCostCenter\Model\Resolver;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Mzat\OrderWithCostCenter\Model\CustomPayment;

/**
 * @inheritdoc
 */
class SetPaymentMethod implements ResolverInterface
{
    /**
     * @inheritdoc
     */
    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        if (!isset($value['model'])) {
            throw new LocalizedException(__('"model" value should be specified'));
        }

        // Set custom payment method
        try {
            $quote = $value['model'];
            $quote->setPaymentMethod(CustomPayment::ORDER_WITH_CUSTOM_PAYMENT_METHOD);
            $quote->getPayment()->importData(['method' => CustomPayment::ORDER_WITH_CUSTOM_PAYMENT_METHOD]);
            $quote->save();

            return true;
        } catch (Exception $e) {
            throw new GraphQlInputException(__('Something went wrong with custom payment method'));
        }

        return false;
    }
}
