<?php
/**
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 *
 * @category    Mzat
 *
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Harun Mujic <harun@web-vision.de>
 */
declare(strict_types=1);
namespace Mzat\OrderWithCostCenter\Plugin;

use Hyva\Checkout\Magewire\Checkout\Payment\MethodList;

class PreselectPayment
{
    /**
     * If payment method is not already set, it sets the Order with Cost Center payment method
     *
     * @param MethodList $subject
     *
     * @return void
     */
    public function afterBoot(MethodList $subject): void
    {

        if ($subject->method === null) {
            $costCenterMethod = $subject->updatedMethod('order_with_cost_center');
            $subject->method = $costCenterMethod;
        }
    }
}
