<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Mzat
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Mzat\UrlRewrite\Model;

use Magento\CatalogUrlRewrite\Model\CategoryUrlPathGenerator as Magento_CategoryUrlPathGenerator;

/**
 * Class for generation category url_path
 */
class CategoryUrlPathGenerator extends Magento_CategoryUrlPathGenerator
{
    /**
     * Generate category url key
     *
     * @param \Magento\Catalog\Model\Category $category
     *
     * @return string
     */
    public function getUrlKey($category)
    {
        $forbiddenChars = UrlFilter::getUrlMpaaping();
        $urlKey = $category->getUrlKey();

        return $category->formatUrlKey($urlKey === '' || $urlKey === null ? strtr($category->getName(), $forbiddenChars) : strtr($urlKey, $forbiddenChars));
    }
}
