<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Mzat
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Mzat\UrlRewrite\Model;

use Magento\Cms\Api\Data\PageInterface;
use Magento\CmsUrlRewrite\Model\CmsPageUrlPathGenerator as Magento_CmsPageUrlPathGenerator;

/**
 * Class for generation cms page url_key
 */
class CmsPageUrlPathGenerator extends Magento_CmsPageUrlPathGenerator
{
    /**
     * Generate CMS page url key based on url_key entered by merchant or page title
     *
     * @param PageInterface $cmsPage
     *
     * @return string
     */
    public function generateUrlKey(PageInterface $cmsPage)
    {
        $forbiddenChars = UrlFilter::getUrlMpaaping();
        $urlKey = $cmsPage->getIdentifier();

        return $this->filterManager->translitUrl($urlKey === '' || $urlKey === null ? strtr($cmsPage->getTitle(), $forbiddenChars) : strtr($urlKey, $forbiddenChars));
    }
}
