<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Mzat
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Mzat\UrlRewrite\Model\Product;

use Magento\Catalog\Model\Product\Url as Magento_Url;
use Mzat\UrlRewrite\Model\UrlFilter;

/**
 * Product Url model
 *
 * @api
 *
 * @since 100.0.2
 */
class Url extends Magento_Url
{
    /**
     * Format Key for URL
     *
     * @param string $str
     *
     * @return string
     */
    public function formatUrlKey($str)
    {
        $forbiddenChars = UrlFilter::getUrlMpaaping();

        return $this->filter->translitUrl(strtr($str, $forbiddenChars));
    }
}
