<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Mzat
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Mzat\UrlRewrite\Model;

use Magento\Catalog\Model\Product;
use Magento\CatalogUrlRewrite\Model\ProductUrlPathGenerator as Magento_ProductUrlPathGenerator;

/**
 * Model product url path generator
 */
class ProductUrlPathGenerator extends Magento_ProductUrlPathGenerator
{
    /**
     * Prepare url key for product
     *
     * @param  Product $product
     *
     * @return string
     */
    protected function prepareProductUrlKey(Product $product)
    {
        $forbiddenChars = UrlFilter::getUrlMpaaping();
        $urlKey = (string)$product->getUrlKey();
        $urlKey = trim(strtolower($urlKey));

        return $product->formatUrlKey($urlKey ?: strtr($product->getName(), $forbiddenChars));
    }

    /**
     * Prepare URL Key with stored product data (fallback for "Use Default Value" logic)
     *
     * @param  Product $product
     *
     * @return string
     */
    protected function prepareProductDefaultUrlKey(Product $product)
    {
        $forbiddenChars = UrlFilter::getUrlMpaaping();
        $storedProduct = $this->productRepository->getById($product->getId());
        $storedUrlKey = $storedProduct->getUrlKey();

        return $storedUrlKey ?: $product->formatUrlKey(strtr($storedProduct->getName(), $forbiddenChars));
    }
}
