<?php
/**
 * web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 *
 * @category    WebVision
 *
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @license     <!--LICENSEURL-->
 * @author      Parth Trivedi <parth@web-vision.de>
 */
namespace WebVision\BannerSlider\Block;

use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Magento\Framework\View\Element\Template;
use WebVision\BannerSlider\Helper\Data as bannerHelper;

/**
 * Class Preload
 */
class Preload extends Template
{
    /**
     * @type bannerHelper
     */
    public $helperData;

    /**
     * Slider constructor.
     *
     * @param Template\Context $context
     * @param bannerHelper $helperData
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        bannerHelper $helperData,
        array $data = []
    ) {
        $this->helperData = $helperData;
        parent::__construct($context, $data);
    }

    /**
     * {@inheritdoc}
     */
    protected function _construct()
    {
        parent::_construct();

        $this->setTemplate('WebVision_BannerSlider::preload.phtml');
    }

    /**
     * @return array|AbstractCollection
     */
    public function getBannerCollection()
    {
        $collection = [];

        if ($this->getPreloadSliders()->getSize()) {
            foreach ($this->getPreloadSliders()->getData() as $singleSlider) {
                $collection[] = $this->helperData->getBannerCollection($singleSlider['slider_id'])->addFieldToFilter('status', 1)->getFirstItem();
            }
        }

        return $collection;
    }

    /**
     * @return array
     */
    public function getPreloadSliders()
    {
        return $this->helperData->getPreloadedSliders();
    }

    public function preloadImages()
    {
        $out = [];

        if ($this->getBannerCollection()) {
            foreach ($this->getBannerCollection() as $banner) {
                $outInner = [];
                $mobileImage = $banner->getImageUrl();
                //-- Webv start
                if ($banner->getImagemobileUrl() && $this->isImageFile($banner->getImagemobileUrl())) {
                    $mobileImage = $banner->getImagemobileUrl();
                }
                //-- Webv end
                $outInner[] = $banner->getImageUrl();
                $outInner[] = $mobileImage;
                $out [] = $outInner;
            }
        }

        return $out;
    }

    //-- Webv start
    /**
     * @param $imgUrl
     *
     * @return string|string[]
     */
    public function isImageFile($imgUrl)
    {
        $allowed = [
           '.jpg',
           '.jpeg',
           '.gif',
           '.png',
           '.webp',
           '.flv',
           ];
        if (!in_array(strtolower(strrchr($imgUrl, '.')), $allowed)) {
            return false;
        }

        return true;
    }
    //-- Webv end
}
