<?php
/**
 * web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.web-vision.de for more information.
 *
 * @category    WebVision
 *
 * @copyright   Copyright (c) 2001-2021 web-vision GmbH (https://www.web-vision.de)
 * @license     <!--LICENSEURL-->
 * @author      Parth Trivedi <parth@web-vision.de>
 */
namespace WebVision\BannerSlider\Block;

use Exception;
use Magento\Cms\Model\Template\FilterProvider;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Magento\Framework\Serialize\SerializerInterface as SerializerInterface;
use Magento\Framework\Stdlib\DateTime\DateTime;
use Magento\Framework\View\Element\Template;
use Magento\Store\Model\StoreManagerInterface;
use WebVision\BannerSlider\Helper\Data as bannerHelper;
use WebVision\BannerSlider\Helper\Media;

/**
 * Class Slider
 */
class Slider extends Template
{
    /**
     * @type bannerHelper
     */
    public $helperData;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @type StoreManagerInterface
     */
    protected $store;

    /**
     * @var CustomerRepositoryInterface
     */
    protected $customerRepository;

    /**
     * @var DateTime
     */
    protected $_date;

    /**
     * @var FilterProvider
     */
    public $filterProvider;

    /**
     * @var Media
     */
    public $imageHandler;

    /**
     * Slider constructor.
     *
     * @param Template\Context $context
     * @param bannerHelper $helperData
     * @param CustomerRepositoryInterface $customerRepository
     * @param DateTime $dateTime
     * @param SerializerInterface $serializer
     * @param FilterProvider $filterProvider
     * @param CategoryTiles $categoryTiles
     * @param Media $imageHandler
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        bannerHelper $helperData,
        CustomerRepositoryInterface $customerRepository,
        DateTime $dateTime,
        SerializerInterface $serializer,
        FilterProvider $filterProvider,
        Media $imageHandler,
        array $data = []
    ) {
        $this->helperData = $helperData;
        $this->customerRepository = $customerRepository;
        $this->store = $context->getStoreManager();
        $this->_date = $dateTime;
        $this->serializer = $serializer;
        $this->filterProvider = $filterProvider;
        $this->imageHandler = $imageHandler;

        parent::__construct($context, $data);
    }

    /**
     * {@inheritdoc}
     */
    protected function _construct()
    {
        parent::_construct();

        $this->setTemplate('WebVision_BannerSlider::bannerslider.phtml');
    }

    /**
     * Get Slider Id
     *
     * @return string
     */
    public function getSliderId()
    {
        if ($this->getSlider()) {
            return $this->getSlider()->getSliderId();
        }

        return time();
    }

    /**
     * @param $content
     *
     * @throws Exception
     *
     * @return string
     */
    public function getPageFilter($content)
    {
        return $this->filterProvider->getPageFilter()->filter($content);
    }

    /**
     * @return array|AbstractCollection
     */
    public function getBannerCollection()
    {
        $collection = [];

        if ($this->getSliderId()) {
            $collection = $this->helperData->getBannerCollection($this->getSliderId())->addFieldToFilter('status', 1);
        }

        return $collection;
    }

    /**
     * @return false|string
     */
    public function getBannerOptions()
    {
        return $this->helperData->getBannerOptions($this->getSlider());
    }

    public function getBannerFormattedData()
    {
        if ($this->getBannerCollection() && $this->getBannerCollection()->getSize()) {
            $items = $this->getBannerCollection();
            $firstItem = null;
            $bannersArray = [];
            $firstKey = $items->getFirstItem()->getId();

            foreach ($items as $_item) {
                $content = $_item->getContent();
                $title = $_item->getTitle();
                $subTitle = $_item->getSubTitle();
                $mobileImage = $_item->getImagemobileUrl();
                $alt = $_item->getName();

                $itemsInner = [];
                $itemInner['link'] = $_item->getUrlBanner();
                $itemInner['target'] = $_item->getNewtab();
                $itemInner['pic'] = $_item->getImageUrl();
                $itemInner['picJpg'] = str_replace('.webp', '.jpg', $_item->getImageUrl());
                $itemInner['picMobile'] = $mobileImage;
                $itemInner['picMobileJpg'] = str_replace('.webp', '.jpg', $mobileImage);
                $itemInner['title'] = $title;
                $itemInner['altText'] = $alt;
                $itemInner['subtitle'] = $subTitle;
                $itemInner['contentText'] = $content;
                $itemInner['imgPosition'] = $_item->getImagePosition();
                $itemInner['actionPrice'] = $_item->getActionPrice();
                $itemInner['defaultPrice'] = $_item->getOldPrice();

                if ($_item->getId() === $firstKey) {
                    $itemInner['index'] = 0;
                    $firstItem = $itemInner;
                } else {
                    $bannersArray[] = $itemInner;
                }
            }

            return [
                'firstItem' => $firstItem,
                'banners' => $this->encodeData($bannersArray),
            ];
        }

        return false;
    }

    /**
    * get Serialize Data
    *
    * @param mixed $data
    *
    * @return string
    */
    public function encodeData($data): string
    {
        return $this->serializer->serialize($data);
    }
}
