<?php
/**
 * web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.web-vision.de for more information.
 *
 * @category    WebVision
 *
 * @copyright   Copyright (c) 2001-2021 web-vision GmbH (https://www.web-vision.de)
 * @license     <!--LICENSEURL-->
 * @author      Parth Trivedi <parth@web-vision.de>
 */
namespace WebVision\BannerSlider\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

/**
 * Class Effect
 */
class Effect implements ArrayInterface
{
    public const SLIDER = 'slider';
    public const FADE_OUT = 'fadeOut';
    public const ROTATE_OUT = 'rotateOut';
    public const FLIP_OUT = 'flipOutX';
    public const ROLL_OUT = 'rollOut';
    public const ZOOM_OUT = 'zoomOut';
    public const SLIDER_OUT_LEFT = 'slideOutLeft';
    public const SLIDER_OUT_RIGHT = 'slideOutRight';
    public const LIGHT_SPEED_OUT = 'lightSpeedOut';

    /**
     * to option array
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [
            [
                'value' => self::SLIDER,
                'label' => __('No'),
            ],
            [
                'value' => self::FADE_OUT,
                'label' => __('fadeOut'),
            ],
            [
                'value' => self::ROTATE_OUT,
                'label' => __('rotateOut'),
            ],
            [
                'value' => self::FLIP_OUT,
                'label' => __('flipOut'),
            ],
            [
                'value' => self::ROLL_OUT,
                'label' => __('rollOut'),
            ],
            [
                'value' => self::ZOOM_OUT,
                'label' => __('zoomOut'),
            ],
            [
                'value' => self::SLIDER_OUT_LEFT,
                'label' => __('slideOutLeft'),
            ],
            [
                'value' => self::SLIDER_OUT_RIGHT,
                'label' => __('slideOutRight'),
            ],
            [
                'value' => self::LIGHT_SPEED_OUT,
                'label' => __('lightSpeedOut'),
            ],
        ];

        return $options;
    }
}
