<?php
/**
 * web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.web-vision.de for more information.
 *
 * @category    WebVision
 *
 * @copyright   Copyright (c) 2001-2021 web-vision GmbH (https://www.web-vision.de)
 * @license     <!--LICENSEURL-->
 * @author      Parth Trivedi <parth@web-vision.de>
 */
namespace WebVision\BannerSlider\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

/**
 * Class Location
 */
class Location implements ArrayInterface
{
    public const ALLPAGE_CONTENT_TOP = 'allpage.content-top';
    public const ALLPAGE_CONTENT_BOTTOM = 'allpage.content-bottom';
    public const ALLPAGE_PAGE_TOP = 'allpage.page-top';
    public const ALLPAGE_PAGE_BOTTOM = 'allpage.footer-container';
    public const HOMEPAGE_CONTENT_TOP = 'cms_index_index.content-top';
    public const HOMEPAGE_CONTENT_BOTTOM = 'cms_index_index.content-bottom';
    public const HOMEPAGE_PAGE_TOP = 'cms_index_index.page-top';
    public const HOMEPAGE_PAGE_BOTTOM = 'cms_index_index.footer-container';
    public const CATEGORY_CONTENT_TOP = 'catalog_category_view.content-top';
    public const CATEGORY_CONTENT_BOTTOM = 'catalog_category_view.content-bottom';
    public const CATEGORY_PAGE_TOP = 'catalog_category_view.page-top';
    public const CATEGORY_PAGE_BOTTOM = 'catalog_category_view.footer-container';
    public const CATEGORY_SIDEBAR_TOP = 'catalog_category_view.sidebar-top';
    public const CATEGORY_SIDEBAR_BOTTOM = 'catalog_category_view.sidebar-bottom';
    public const PRODUCT_CONTENT_TOP = 'catalog_product_view.content-top';
    public const PRODUCT_CONTENT_BOTTOM = 'catalog_product_view.content-bottom';
    public const PRODUCT_PAGE_TOP = 'catalog_product_view.page-top';
    public const PRODUCT_PAGE_BOTTOM = 'catalog_product_view.footer-container';

    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $options = [
            [
                'label' => __('All Page'),
                'value' => [
                    [
                        'label' => __('Top of content'),
                        'value' => self::ALLPAGE_CONTENT_TOP,
                    ],
                    [
                        'label' => __('Bottom of content'),
                        'value' => self::ALLPAGE_CONTENT_BOTTOM,
                    ],
                    [
                        'label' => __('Top of page'),
                        'value' => self::ALLPAGE_PAGE_TOP,
                    ],
                    [
                        'label' => __('Bottom of page'),
                        'value' => self::ALLPAGE_PAGE_BOTTOM,
                    ],
                ],
            ],
            [
                'label' => __('Home Page'),
                'value' => [
                    [
                        'label' => __('Top of content'),
                        'value' => self::HOMEPAGE_CONTENT_TOP,
                    ],
                    [
                        'label' => __('Bottom of content'),
                        'value' => self::HOMEPAGE_CONTENT_BOTTOM,
                    ],
                    [
                        'label' => __('Top of page'),
                        'value' => self::HOMEPAGE_PAGE_TOP,
                    ],
                    [
                        'label' => __('Bottom of page'),
                        'value' => self::HOMEPAGE_PAGE_BOTTOM,
                    ],
                ],
            ],
            [
                'label' => __('Category page'),
                'value' => [
                    [
                        'label' => __('Top of content'),
                        'value' => self::CATEGORY_CONTENT_TOP,
                    ],
                    [
                        'label' => __('Bottom of content'),
                        'value' => self::CATEGORY_CONTENT_BOTTOM,
                    ],
                    [
                        'label' => __('Top of page'),
                        'value' => self::CATEGORY_PAGE_TOP,
                    ],
                    [
                        'label' => __('Bottom of page'),
                        'value' => self::CATEGORY_PAGE_BOTTOM,
                    ],
                    [
                        'label' => __('Top of sidebar'),
                        'value' => self::CATEGORY_SIDEBAR_TOP,
                    ],
                    [
                        'label' => __('Bottom of sidebar'),
                        'value' => self::CATEGORY_SIDEBAR_BOTTOM,
                    ],
                ],
            ],
            [
                'label' => __('Product page'),
                'value' => [
                    [
                        'label' => __('Top of content'),
                        'value' => self::PRODUCT_CONTENT_TOP,
                    ],
                    [
                        'label' => __('Bottom of content'),
                        'value' => self::PRODUCT_CONTENT_BOTTOM,
                    ],
                    [
                        'label' => __('Top of page'),
                        'value' => self::PRODUCT_PAGE_TOP,
                    ],
                    [
                        'label' => __('Bottom of page'),
                        'value' => self::PRODUCT_PAGE_BOTTOM,
                    ],
                ],
            ],
        ];

        return $options;
    }
}
