<?php
/**
 * web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.web-vision.de for more information.
 *
 * @category    WebVision
 *
 * @copyright   Copyright (c) 2001-2021 web-vision GmbH (https://www.web-vision.de)
 * @license     <!--LICENSEURL-->
 * @author      Parth Trivedi <parth@web-vision.de>
 */
namespace WebVision\BannerSlider\Model\ResourceModel\Banner;

use Magento\Framework\DB\Select;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Zend_Db_Select;

/**
 * Class Collection
 */
class Collection extends AbstractCollection
{
    /**
     * ID Field Name
     *
     * @var string
     */
    protected $_idFieldName = 'banner_id';

    /**
     * Event prefix
     *
     * @var string
     */
    protected $_eventPrefix = 'webvision_bannerslider_banner_collection';

    /**
     * Event object
     *
     * @var string
     */
    protected $_eventObject = 'banner_collection';

    /**
     * Define resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init('WebVision\BannerSlider\Model\Banner', 'WebVision\BannerSlider\Model\ResourceModel\Banner');
    }

    /**
     * Get SQL for get record count.
     * Extra GROUP BY strip added.
     *
     * @return Select
     */
    public function getSelectCountSql()
    {
        $countSelect = parent::getSelectCountSql();
        $countSelect->reset(Zend_Db_Select::GROUP);

        return $countSelect;
    }

    /**
     * @param string $valueField
     * @param string $labelField
     * @param array $additional
     *
     * @return array
     */
    protected function _toOptionArray($valueField = 'banner_id', $labelField = 'name', $additional = [])
    {
        return parent::_toOptionArray($valueField, $labelField, $additional);
    }

    /**
     * @param array|string $field
     * @param null $condition
     *
     * @return AbstractCollection
     */
    public function addFieldToFilter($field, $condition = null)
    {
        if ($field === 'banner_id') {
            $field = 'main_table.banner_id';
        }

        if ($field === 'type' && isset($condition['like'])) {
            $condition['like'] = str_replace("'%", '', $condition['like']);
            $condition['like'] = str_replace("%'", '', $condition['like']);

            if (stripos('Image', $condition['like']) !== false) {
                $condition = 0;
            }

            if (stripos('Advanced', $condition['like']) !== false) {
                $condition = 1;
            }
        }

        if ($field === 'status' && isset($condition['like'])) {
            $condition['like'] = str_replace("'%", '', $condition['like']);
            $condition['like'] = str_replace("%'", '', $condition['like']);

            if (stripos('Enable', $condition['like']) !== false) {
                $condition = 1;
            }

            if (stripos('Disable', $condition['like']) !== false) {
                $condition = 0;
            }
        }

        return parent::addFieldToFilter($field, $condition); // TODO: Change the autogenerated stub
    }
}
