<?php
/**
 * web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.web-vision.de for more information.
 *
 * @category    WebVision
 *
 * @copyright   Copyright (c) 2001-2021 web-vision GmbH (https://www.web-vision.de)
 * @license     <!--LICENSEURL-->
 * @author      Parth Trivedi <parth@web-vision.de>
 */
namespace WebVision\BannerSlider\Observer;

use Magento\Framework\App\RequestInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\View\Layout;
use WebVision\BannerSlider\Block\Slider;
use WebVision\BannerSlider\Helper\Data;

/**
 * Class AddBlock
 */
class AddBlock implements ObserverInterface
{
    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @var Data
     */
    protected $helperData;

    /**
     * AddBlock constructor.
     *
     * @param RequestInterface $request
     * @param Data $helperData
     */
    public function __construct(
        RequestInterface $request,
        Data $helperData
    ) {
        $this->request = $request;
        $this->helperData = $helperData;
    }

    /**
     * @param Observer $observer
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     *
     * @return $this
     */
    public function execute(Observer $observer)
    {
        if (!$this->helperData->isEnabled()) {
            return $this;
        }

        $type = array_search($observer->getEvent()->getElementName(), [
            'header' => 'header',
            'content' => 'content',
            'page-top' => 'page.top',
            'footer-container' => 'footer-container',
            'sidebar' => 'catalog.leftnav',
        ], true);

        if ($type !== false) {
            /** @var Layout $layout */
            $layout = $observer->getEvent()->getLayout();
            $fullActionName = $this->request->getFullActionName();
            $output = $observer->getTransport()->getOutput();

            foreach ($this->helperData->getActiveSliders() as $slider) {
                if (!empty($slider->getLocation())) {
                    $locations = explode(',', $slider->getLocation());

                    if (!empty($locations[0])) {
                        foreach ($locations as $value) {
                            list($pageType, $location) = explode('.', $value);

                            if (($fullActionName === $pageType || $pageType === 'allpage') &&
                                strpos($location, $type) !== false
                            ) {
                                $content = $layout->createBlock(Slider::class)
                                    ->setSlider($slider)
                                    ->toHtml();

                                if (strpos($location, 'top') !== false) {
                                    $output = "<div id=\"webvision-bannerslider-block-before-{$type}-{$slider->getId()}\">
                                                $content</div>" . $output;
                                } else {
                                    $output .= "<div id=\"webvision-bannerslider-block-after-{$type}-{$slider->getId()}\">
                                                $content</div>";
                                }
                            }
                        }
                    }
                }
            }

            $observer->getTransport()->setOutput($output);
        }

        return $this;
    }
}
