/**
 * web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.web-vision.de for more information.
 *
 * @category    WebVision
 * @package     WebVision/BannerSlider
 * @copyright   Copyright (c) 2001-2021 web-vision GmbH (https://www.web-vision.de)
 * @license     <!--LICENSEURL-->
 * @author      Parth Trivedi <parth@web-vision.de>
 */

define([
    'jquery'
], function ($) {
    "use strict";

    $.widget('webvision.bannerslider', {
        /**
         * This method constructs a new widget.
         * @private
         */
        _create: function () {
            this.templates = JSON.parse(this.options.templateHtml);
            this.imgUrls = JSON.parse(this.options.imgUrls);
            this.tplDropdown = $('#banner_default_template');
            this.initObserve();
        },
        initObserve: function () {
            this.loadTemplate();
            this.changeImageUrl();
        },
        loadTemplate: function () {
            var self = this;
            var toggleMCEEditor = $('#togglebanner_content');
            var bannerContent = $('#banner_content');
            var btnLoadContent = $('#banner_load_template');
            btnLoadContent.on('click', function () {
                var tplId = self.tplDropdown.val();
                var tpl = self.templates[tplId]["tpl"];
                var replaceBy = self.templates[tplId]["var"];
                var regEx = new RegExp(replaceBy, 'g');
                var html = tpl.replace(regEx, tplId);

                if (bannerContent.css('display') === 'none') {
                    toggleMCEEditor.trigger('click');
                }
                bannerContent.val(html);
            });
        },
        changeImageUrl: function () {
            var imageUrls = this.imgUrls;
            var demoImg = $('#mp-demo-image');
            this.tplDropdown.on('change', function () {
                demoImg.attr('src', imageUrls[$(this).val()]);
            })
        }
    });

    return $.webvision.bannerslider;
});
