<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */

namespace WebVision\CustomDataSearch\Api\Data;

interface CustomDataInterface
{
    /**
     * Constants for keys of data array. Identical to the name of the getter in snake case.
     */
    const TABLE_NAME = 'custom_data_search';
    const ID = 'id';
    const TITLE = 'title';
    const CONTENT = 'content';
    const SUB_CATEGORIES = 'sub_categories';
    const URL = 'url';
    const CAT_ID = 'cat_id';
    const STORE_ID = 'store_id';
    const STATUS = 'status';
    const CREATED_AT = 'CREATED_AT';
    const UPDATED_AT = 'UPDATED_AT';

    const PENDING_STATUS = 0;
    const PROCESS_STATUS = 1;
    const RUNNIG_STATUS = 2;
    const SUCCESS_STATUS = 3;
    const READY_STATUS = 4;
    const FAILED_STATUS = 5;

    const DEFAULT_DATETIME_FORMATE = 'Y-m-d H:i:s';
    const NEW_DATETIME_FORMATE = 'l, F j, Y \a\t g:i:s A';


   /**
    * Get Id.
    *
    * @return int
    */
    public function getId();

   /**
    * Set Id.
    */
    public function setId($id);

   /**
    * Get Title.
    *
    * @return varchar
    */
    public function getTitle();

   /**
    * Set Title.
    */
    public function setTitle($title);

   /**
    * Get Content.
    *
    * @return varchar
    */
    public function getContent();

   /**
    * Set Content.
    */
    public function setContent($content);

    /**
    * Get Url.
    *
    * @return varchar
    */
    public function getUrl();

   /**
    * Set Url.
    */
    public function setUrl($url);


    /**
    * Get Category Id.
    *
    * @return varchar
    */
    public function getCatId($catId);

   /**
    * Set Category Id
    */
    public function setCatId($catId);

    /**
    * Get Store Id.
    *
    * @return varchar
    */
    public function getStoreId($storeId);

   /**
    * Set Store Id
    */
    public function setStoreId($storeId);

    /**
    * Get Status
    *
    * @return varchar
    */
    public function getStatus();

   /**
    * Set Status
    */
    public function setStatus($status);

}