<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Block\Adminhtml\System\StoreFilter;

use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\DataObject;
use WebVision\CustomDataSearch\Block\Adminhtml\System\StoreFilter\Field\StoreList;

class DynamicFieldData extends AbstractFieldArray
{
    /**
     * @var StoreList
     */
    private $showStoreRenderer;

    /**
     * @inheritdoc
     */
    protected function _prepareToRender()
    {
        $this->addColumn(
            'attr_store',
            [
                'label' => __('Magento Store With Code'),
                'renderer' => $this->getStoreList(),
                'name' => 'show_label',
                'class' => 'attr_store_options',
                'style' => 'width:300px',
            ]
        );

        $this->addColumn(
            'attr_id',
            [
                'label' => __('Custom Store ID'),
                'class' => 'required-entry',
                'style' => 'width:100px',
            ]
        );

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add More Store');
    }

    /**
     * @inheritdoc
     */
    protected function _prepareArrayRow(DataObject $row)
    {
        $options = [];
        $countryList = $row->getAttrStore();
        if ($countryList !== null) {
            $options['option_' . $this->getStoreList()->calcOptionHash($countryList)] = 'selected="selected"';
        }
        $row->setData('option_extra_attrs', $options);
    }

    /**
     * Get Store list
     *
     * @return array
     */
    private function getStoreList()
    {
        if (!$this->showStoreRenderer) {
            $this->showStoreRenderer = $this->getLayout()->createBlock(
                StoreList::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }

        return $this->showStoreRenderer;
    }
}
