<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Block\Adminhtml\System\StoreFilter\Field;

use Magento\Framework\View\Element\Context;
use Magento\Framework\View\Element\Html\Select;
use Magento\Store\Api\StoreRepositoryInterface;

class StoreList extends Select
{
    /**
     * @var StoreRepositoryInterface
     */
    protected $storeRepository;

    /**
     * @param Context $context
     * @param StoreRepositoryInterface $storeRepository
     * @param array $data
     */
    public function __construct(
        Context $context,
        StoreRepositoryInterface $storeRepository,
        array $data = []
    ) {
        $this->storeRepository = $storeRepository;
        parent::__construct($context, $data);
    }

    /**
     * Set input name
     *
     * @param string $value
     *
     * @return string
     */
    public function setInputName($value)
    {
        return $this->setName($value);
    }

    /**
     * Set input id
     *
     * @param string $value
     *
     * @return string
     */
    public function setInputId($value)
    {
        return $this->setId($value);
    }

    /**
     * @inheritdoc
     */
    public function _toHtml()
    {
        if (!$this->getOptions()) {
            $this->setOptions($this->getSourceOptions());
        }

        return parent::_toHtml();
    }

    /**
     * get source options data
     *
     * @return array
     */
    private function getSourceOptions()
    {
        $options = [];
        $storeList = $this->storeRepository->getList();
        foreach ($storeList as $store) {
            if ($store->getStoreId()) {
                $options[] = ['label' => $store->getName() . ' ( ' . $store->getCode() . ' )', 'value' => $store->getStoreId()];
            }
        }

        return $options;
    }
}
