<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Block;

use WebVision\CustomDataSearch\Api\Data\CustomDataInterface as CustomData;

class AllCustomDataPages extends CustomDataPages
{
    public const PAGES_MINIMUM_PAGE_SHOW = 5;

    /**
     * @var \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\DataProvider
     */
    protected $itemFactory;

    /**
     * @var \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\ItemFactory
     */
    protected $customdataPages;

    /**
     * @var \WebVision\CustomDataSearch\Helper\Data
     */
    protected $customdataHelper;

    /**
     * @var \Magento\CatalogSearch\Block\Result
     */
    protected $searchPageResult;

    /**
     * @var \WebVision\CustomDataSearch\Model\CustomSearcManage
     */
    private $customSearcManage;

    /**
     * @var \WebVision\CustomDataSearch\Model\PagesFactory
     */
    protected $customdataPagesFactory;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\DataProvider $customdataPages
     * @param \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\ItemFactory $itemFactory
     * @param \WebVision\CustomDataSearch\Helper\Data $customdataHelper
     * @param \Magento\CatalogSearch\Block\Result $searchPageResult
     * @param \WebVision\CustomDataSearch\Model\CustomDataSearchFactory $customdataPagesFactory
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\DataProvider $customdataPages,
        \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\ItemFactory $itemFactory,
        \WebVision\CustomDataSearch\Helper\Data $customdataHelper,
        \Magento\CatalogSearch\Block\Result $searchPageResult,
        \WebVision\CustomDataSearch\Model\CustomSearcManage $customSearcManage,
        \WebVision\CustomDataSearch\Model\CustomDataSearchFactory $customdataPagesFactory,
        array $data = []
    ) {
        $this->customdataPages = $customdataPages;
        $this->itemFactory = $itemFactory;
        $this->customdataHelper = $customdataHelper;
        $this->searchPageResult = $searchPageResult;
        $this->customSearcManage = $customSearcManage;
        $this->customdataPagesFactory = $customdataPagesFactory;
        parent::__construct(
            $context,
            $customdataPages,
            $itemFactory,
            $customdataHelper,
            $searchPageResult,
            $customSearcManage,
            $data
        );
    }

    /**
     * @inheritDoc
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        $page_size = $this->getPagerCount();
        $page_data = $this->getAllPageData();
        if ($this->getAllPageData()) {
            $pager = $this->getLayout()->createBlock(
                \Magento\Theme\Block\Html\Pager::class,
                'customdata.page.pager'
            )
                ->setAvailableLimit($page_size)
                ->setPageVarName('tp')
                ->setShowPerPage(true)
                ->setCollection($page_data);
            $this->setChild('pager', $pager);
            $this->getAllPageData()->load();
        }

        return $this;
    }

    /**
     * get pager html
     *
     * @return string
     */
    public function getPagerHtml()
    {
        return $this->getChildHtml('pager');
    }

    /**
     * get all pages data
     *
     * @return object
     */
    public function getAllPageData()
    {
        // get param values
        $page = ($this->getRequest()->getParam('tp')) ? $this->getRequest()->getParam('tp') : 1;
        $pageSize = ($this->getRequest()->getParam('limit')) ? $this->getRequest()->getParam('limit') : self::PAGES_MINIMUM_PAGE_SHOW;

        // get customdata page collection
        $dataIds = $this->getCustomDataCollection(false)->getColumnValues(CustomData::ID);
        $collection = $this->customdataPagesFactory->create()->getCollection();
        $collection->addFieldToFilter(CustomData::ID, ['in' => $dataIds ]);
        $collection->setPageSize($pageSize);
        $collection->setCurPage($page);
        return $collection;
    }

    /**
     * get per page dynamic count
     *
     * @return object
     */
    public function getPagerCount()
    {
        $minimumShow = self::PAGES_MINIMUM_PAGE_SHOW;
        $pageArray = [];
        if($listData = $this->getCustomDataCollection()) {
            $listCount = ceil(count($listData->getData()));
            $showCount = $minimumShow + 1;
            if (count($listData->getData()) >= $showCount) {
                $listCount = $listCount / $minimumShow;
                $pageNumber = $total = $minimumShow;
                $pageArray[$minimumShow] = $minimumShow;
                for ($x = 0; $x <= $listCount; $x++) {
                    $total = $total + $pageNumber;
                    $pageArray[$total] = $total;
                }
            } else {
                $pageArray[$minimumShow] = $minimumShow;
                $minimumShow = $minimumShow + $minimumShow;
                $pageArray[$minimumShow] = $minimumShow;
            }
        }

        return $pageArray;
    }

    /**
     * Undocumented function
     *
     * @return string
     */
    public function getPageLimit() {
        $limit = $this->getRequest()->getParam('limit') ?? self::PAGES_MINIMUM_PAGE_SHOW;
        $page = $this->getRequest()->getParam('tp') ?? 0;
        $pageLimit = ($page ? $limit * $page - $limit : 0) + 1;

        return $pageLimit;
    }
}