<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Block;

use Magento\Framework\View\Element\Template;

class CustomDataPages extends Template
{
    /**
     * @var \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\DataProvider
     */
    protected $itemFactory;

    /**
     * @var \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\ItemFactory
     */
    protected $customdataPages;

    /**
     * @var \WebVision\CustomDataSearch\Helper\Data
     */
    protected $customdataHelper;

    /**
     * @var \Magento\CatalogSearch\Block\Result
     */
    protected $searchPageResult;

    /**
     * @var \WebVision\CustomDataSearch\Model\CustomSearcManage
     */
    private $customSearcManage;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\DataProvider $customdataPages
     * @param \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\ItemFactory $itemFactory
     * @param \WebVision\CustomDataSearch\Helper\Data $customdataHelper
     * @param \Magento\CatalogSearch\Block\Result $searchPageResult
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\DataProvider $customdataPages,
        \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\ItemFactory $itemFactory,
        \WebVision\CustomDataSearch\Helper\Data $customdataHelper,
        \Magento\CatalogSearch\Block\Result $searchPageResult,
        \WebVision\CustomDataSearch\Model\CustomSearcManage $customSearcManage,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->customdataPages = $customdataPages;
        $this->itemFactory = $itemFactory;
        $this->customdataHelper = $customdataHelper;
        $this->searchPageResult = $searchPageResult;
        $this->customSearcManage = $customSearcManage;
    }

    /**
     * Get customdata data collection
     *
     * @param bool $size
     *
     * @return \WebVision\CustomDataSearch\Model\Autocomplete\Typo3\DataProvider
     */
    public function getCustomDataCollection($size = true)
    {
        $customdataColl = null;
        $customdataStatus = $this->customdataHelper->getCustomDataSearchStatus();
        $customdataSearchPageStatus = $this->customdataHelper->getCustomDataSearchPageStatus();

        if (($customdataStatus) && ($customdataSearchPageStatus)) {
            $customdataColl = $this->customdataPages->getCustomDataCollection($size);
        }

        return $customdataColl;
    }

    /**
     * Get customdata page url
     *
     * @param mixed $url
     *
     * @return string
     */
    public function getPageUrl($url)
    {
        return $this->itemFactory->getPageUrl($url);
    }

    /**
     * Get customdata helper class
     *
     * @return \WebVision\CustomDataSearch\Helper\Data
     */
    public function getCustomDataHelper()
    {
        return $this->customdataHelper;
    }

    /**
     * Get product result count value
     *
     * @return string
     */
    public function getSearchPageProductCount()
    {
        return $this->searchPageResult->getResultCount();
    }

    /**
     * Get customdata search manager class
     *
     * @return \WebVision\CustomDataSearch\Model\CustomSearcManage
     */
    public function getCustomDataSearchManage()
    {
        return $this->customSearcManage;
    }
}
